<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobileSettings_RouteGeneralSettings_View extends Settings_Vtiger_Index_View {

    function __construct() {
        parent::__construct();
    }

    public function preProcess(Vtiger_Request $request) {
        parent::preProcess($request);        
    }

    public function process(Vtiger_Request $request) {
        $module = $request->getModule();
        $adb = PearDatabase::getInstance();
        $mode = $request->getMode();
        $viewer = $this->getViewer($request);
        $generalSettings = CTMobileSettings_Module_Model::getRouteGeneralSettings();
        
        $Users =$adb->pquery("SELECT * FROM `vtiger_users` WHERE deleted = 0 AND status = ?",array('Active'));
        $userArray = array();
        for($i=0;$i<($adb->num_rows($Users));$i++){
            $id = $adb->query_result($Users,$i,'id');
            $name = $adb->query_result($Users,$i,'first_name').' '.$adb->query_result($Users,$i,'last_name');
            $userArray[] = array('userid'=>$id,'username'=>$name);
        }
        $routeStatus = CTMobileSettings_Module_Model::getRouteStatusFields();
        $viewer->assign('DISTANCE_UNIT', $generalSettings['distance_unit']);
        $viewer->assign('ROUTE_USERS', $generalSettings['route_users']);
        $viewer->assign('USER_MODEL', $userArray);
        $viewer->assign('ROUTE_STATUS', $routeStatus);
        echo $viewer->view('RouteGeneralSettings.tpl',$module,true);
    } 

    /**
     * Function to get the list of Script models to be included
     * @param Vtiger_Request $request
     * @return <Array> - List of Vtiger_JsScript_Model instances
     */
    function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            "modules.CTMobileSettings.resources.RouteGeneralSettings",
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }
}
