<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
require_once 'vtlib/Vtiger/Net/Client.php';

class CTMobileSettings_StepAjax_Action extends Vtiger_BasicAjax_Action {
    public function process(Vtiger_Request $request) {	
       	$step = $request->get('step');
       	global $adb,$root_directory;
		$url = CTMobileSettings_Module_Model::$CTMOBILE_VERSION_URL;
       	if($step == 0){
       		$moduleName = "";
	        $serviceURL = $url;
			$postData =  array( "vt_version"=>'6.x');
			$httpClient = new Vtiger_Net_Client($serviceURL);
		    $results = $httpClient->doPost($postData);
		    $results = trim($results);
			$jason_result = json_decode($results,true);
			$zip_url = $jason_result['ext_path'];
			$ext_version = $jason_result['ext_version'];
			if(file_exists($root_directory."/test/".$ext_version."/CTMobileupgrade.zip")){
				$destination_path = $root_directory."/test/".$ext_version."/CTMobileupgrade.zip";
			}else{
				mkdir($root_directory."/test/".$ext_version, 0777);
				$destination_path = $root_directory."/test/".$ext_version."/CTMobileupgrade.zip";
				file_put_contents($destination_path, fopen($zip_url, 'r'));
				chmod($root_directory."/test/".$ext_version."/CTMobileupgrade.zip",0755);
				$zip = new ZipArchive;
				$res = $zip->open($root_directory."/test/".$ext_version."/CTMobileupgrade.zip");
				if ($res === TRUE) {
					$zip->extractTo($root_directory."/test/".$ext_version."/");
					$zip->close();
				}
			}

			$response = new Vtiger_Response();
			$response->setResult(true);
			$response->emit();
       	}else if($step == 1 || $step == '1'){
       		$moduleName = 'CTMobile';
       	}else if($step == 2 || $step == '2'){
       		$moduleName = 'CTTimeTracker';
       	}else if($step == 3 || $step == '3'){
       		$moduleName = 'CTTimeControl';
       	}else if($step == 4 || $step == '4'){
       		$moduleName = 'CTRoutePlanning';
       	}else if($step == 5 || $step == '5'){
       		$moduleName = 'CTRouteAttendance';
       	}else if($step == 6 || $step == '6'){
       		$moduleName = 'CTAttendance';
       	}else if($step == 7 || $step == '7'){
       		$moduleName = 'CTUserFilterView';
       	}else if($step == 8 || $step == '8'){
       		$moduleName = 'CTMessageTemplate';
       	}else if($step == 9 || $step == '9'){
       		$moduleName = 'CTPushNotification';
       	}else if($step == 10 || $step == '10'){
       		$moduleName = 'CTMobileSettings';
       	}

       	if($moduleName != ''){
	        $serviceURL = $url;
			$postData =  array( "vt_version"=>'6.x');
			$httpClient = new Vtiger_Net_Client($serviceURL);
		    $results = $httpClient->doPost($postData);
		    $results = trim($results);
		    $jason_result = json_decode($results,true);
			$zip_url = $jason_result['ext_path'];
			$ext_version = $jason_result['ext_version'];

			$package = new Vtiger_Package();
			if(!getTabid($moduleName)){
				$package->import($root_directory."/test/".$ext_version.'/'.$moduleName.'.zip',true);
			}else{
				$package->update(Vtiger_Module::getInstance($moduleName),$root_directory."/test/".$ext_version.'/'.$moduleName.'.zip');
			}

			if($moduleName != 'CTMobileSetttings' && $moduleName != 'CTMobile'){
		        $result = $adb->pquery("SELECT * FROM vtiger_ws_entity WHERE name = ?",array($moduleName));
		        if($adb->num_rows($result) == 0){
		        	$selentity = $adb->pquery("SELECT id FROM vtiger_ws_entity_seq",array());
		        	$id = $adb->query_result($selentity,0,'id');
		        	$entityid = $id+1;
		        	$adb->pquery("INSERT INTO vtiger_ws_entity (id,name,handler_path,handler_class,ismodule) VALUES (?,?,?,?,?)",array($entityid,$moduleName,'include/Webservices/VtigerModuleOperation.php','VtigerModuleOperation','1'));
		        	$adb->pquery("UPDATE vtiger_ws_entity_seq SET id = ?",$entityid);
		        }

		        $result = $adb->pquery("SELECT * FROM vtiger_ws_entity WHERE name = ?",array($moduleName));
		        if($adb->num_rows($result) == 0){
		            $selentity = $adb->pquery("SELECT MAX(id) as maxid FROM vtiger_ws_entity",array());
		            $maxid = $adb->query_result($selentity,0,'maxid');
		            $entityid = $maxid+1;
		            $adb->pquery("INSERT INTO vtiger_ws_entity (id,name,handler_path,handler_class,ismodule) VALUES (?,?,?,?,?)",array($entityid,$moduleName,'include/Webservices/VtigerModuleOperation.php','VtigerModuleOperation','1'));
		            $adb->pquery("UPDATE vtiger_ws_entity_seq SET id = ?",$entityid);
		        }
			}

			$checkModulePresence = $adb->pquery("SELECT * FROM vtiger_tab WHERE tabid = ? AND presence = '1' ",array(getTabid($moduleName)));
			if($adb->num_rows($checkModulePresence) > 0){
				$moduleManagerModel = new Settings_ModuleManager_Module_Model();
				$moduleManagerModel->enableModule($moduleName);
			}

			$version=$adb->pquery("UPDATE vtiger_tab SET version = ? where name=? ",array($ext_version,$moduleName));

			$path  = $root_directory.'modules/'.$moduleName;
	    	chmod($path, 0755);
	    	$path  = $root_directory.'layouts/vlayout/modules/'.$moduleName;
	    	chmod($path, 0755);
			$response = new Vtiger_Response();
			$response->setResult(true);
			$response->emit();
       	}
    }
}
