<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobile_WS_FetchFieldByType extends CTMobile_WS_Controller {

	function process(CTMobile_API_Request $request) {
		global $current_user,$adb;
		$current_user = $this->getActiveUser();

		$module = $request->get('module');
		$record = $request->get('record');
		$typeoffield = $request->get('fieldtype');
		$id_components = explode('x',$record);
		$recordid = $id_components[1];

		$fields = array();
		if($module && $recordid){
			$recordModel = Vtiger_Record_Model::getInstanceById($recordid,$module);
			$moduleModel = Vtiger_Module_Model::getInstance($module);
			$fieldList = $moduleModel->getFields();
			if($typeoffield == 'phone'){
				foreach ($fieldList as $key => $field) {
					$fielddatatype = $field->getFieldDataType();
					$fieldname = $field->get('name');
					if($field->get('uitype') == '11' && $recordModel->get($fieldname) != ''){
						$fields[] = array('name'=>$fieldname,'label'=>$field->get('label'),'value'=>$recordModel->get($fieldname));
					}
				}
			}else{
				foreach ($fieldList as $key => $field) {
					$fielddatatype = $field->getFieldDataType();
					$fieldname = $field->get('name');
					if($fielddatatype == 'email' && $recordModel->get($fieldname) != ''){
						$fields[] = array('name'=>$fieldname,'label'=>$field->get('label'),'value'=>$recordModel->get($fieldname));
					}
				}
			}
		}

		$response = new CTMobile_API_Response();
		if(count($fields) > 0){
			$response->setResult(array('fields'=>$fields));
		}else{
			$message = "No information found";
			$response->setError(404,$message);
		}
		return $response;
		
	}
}
