<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
include_once dirname(__FILE__) . '/SaveRecord.php';
include_once 'modules/Vtiger/CRMEntity.php';

class CTMobile_WS_AddRecordComment extends CTMobile_WS_SaveRecord {
	
	function process(CTMobile_API_Request $request) {
		global $current_user,$adb, $site_URL;
		$values = Zend_Json::decode($request->get('values'));
		$recordid = trim($request->get('record'));
		$relatedTo = trim($values['related_to']);
		$commentContent = $values['commentcontent'];
		$mentioned_users = explode(',',$request->get('mentioned_user_id'));
		$request->set('mentioned_user_id','');
		if($commentContent == ''){
			$commentContent = $request->get('commentcontent');
		}
		
		if($relatedTo == ''){		
			$message = $this->CTTranslate('Required fields not found');		
			throw new WebServiceException(404,$message);		
		}		
		if($commentContent == ''){		
			$message = $this->CTTranslate('Required fields not found');		
			throw new WebServiceException(404,$message);		
		}

		$current_user = $this->getActiveUser();
		$user = $this->getActiveUser();
		$targetModule = 'ModComments';
		$response = false;
		if (vtlib_isModuleActive($targetModule)) {
			$request->set('module', $targetModule);
			$values['assigned_user_id'] = sprintf('%sx%s', CTMobile_WS_Utils::getEntityModuleWSId('Users'), $user->id);
			//$values['userid'] = $values['assigned_user_id'];
			$request->set('values', Zend_Json::encode($values) );
			
			/*$response = parent::process($request);
			$id = $response->result['id'];*/

			$currentUserModel = Users_Record_Model::getCurrentUserModel();
			$commentsWSid = CTMobile_WS_Utils::getEntityModuleWSId('ModComments');
			if($recordid){
				$recordId = substr($recordid, stripos($recordid, 'x')+1);
				$recordModel = Vtiger_Record_Model::getInstanceById($recordId, $targetModule);
			    $recordModel->set('id', $recordId);
			    $recordModel->set('mode', 'edit');
			    $recordModel->set('assigned_user_id', $currentUserModel->getId());
			    $recordModel->set('userid', $currentUserModel->getId());
			    $relatedCRMid = substr($relatedTo, stripos($relatedTo, 'x')+1);
			    $recordModel->set('related_to', $relatedCRMid);
			    $parent_comments = substr($values['parent_comments'], stripos($values['parent_comments'], 'x')+1);
			    $recordModel->set('parent_comments', $parent_comments);
			    $recordModel->set('is_private', 0);
			    $recordModel->set('related_email_id', 0);
			    $recordModel->set('commentcontent', $request->getRaw('commentcontent'));
		        $recordModel->set('reasontoedit', $request->getRaw('reasontoedit'));
		        $recordModel->save();
		        $savedRecordId = $recordModel->getId();
		        $id = $commentsWSid.'x'.$savedRecordId;
			}else{
				$recordModel = Vtiger_Record_Model::getCleanInstance($targetModule);
			    $recordModel->set('mode', '');
			    $recordModel->set('assigned_user_id', $currentUserModel->getId());
			    $recordModel->set('userid', $currentUserModel->getId());
			    $relatedCRMid = substr($relatedTo, stripos($relatedTo, 'x')+1);
			    $recordModel->set('related_to', $relatedCRMid);
			    $parent_comments = substr($values['parent_comments'], stripos($values['parent_comments'], 'x')+1);
			    $recordModel->set('parent_comments', $parent_comments);
			    $recordModel->set('commentcontent', $request->getRaw('commentcontent'));
			    $recordModel->set('is_private', 0);
			    $recordModel->set('related_email_id', 0);
			    $recordModel->save();
			    $savedRecordId = $recordModel->getId();
			    $id = $commentsWSid.'x'.$savedRecordId;
			}

			
				//$adb->pquery("UPDATE vtiger_modcomments SET userid = ? WHERE modcommentsid = ?",array($current_user->id,$lastInsertId));
				$uploadedFileNames = array();
				foreach ($_FILES as $key => $files) {
					$uploadedFileNames[] = $this->uploadAndSaveFiles($files,$savedRecordId);
				}
				if(count($uploadedFileNames)){
					$filename = implode(',',$uploadedFileNames);
					$adb->pquery("UPDATE vtiger_modcomments SET filename = ? WHERE modcommentsid = ?",array($filename,$savedRecordId));
				}

			//code start for notification of mentioned in comment by suresh
			$license_data = CTMobileSettings_Module_Model::getLicenseData();
			if(!empty($mentioned_users) && strtolower($license_data['Plan']) != 'free'){
				$main_perm_query = "SELECT * FROM ctmobile_notification_settings WHERE notification_type = 'comment_mentioned' AND notification_enabled = '1'";
				$main_perm_result = $adb->pquery($main_perm_query,array());
				if($adb->num_rows($main_perm_result)){
					$notification_id = $adb->query_result($main_perm_result,0,'notification_id');
					$title = decode_html(decode_html($adb->query_result($main_perm_result,0,'notification_title')));
					$message = decode_html(decode_html($adb->query_result($main_perm_result,0,'notification_message')));
					$commmentid = explode('x', $id);
					$message = getMergedDescription($message, $commmentid[1], 'ModComments');
					$assigned_user_id = $user->id;
					$userRecordModel = Users_Record_Model::getInstanceById($assigned_user_id,'Users');
					if($userRecordModel->get('user_name') == ''){
						$query = "SELECT groupname FROM vtiger_groups WHERE groupid = ?";
						$groupResults = $adb->pquery($query,array($assigned_user_id));
						$user_name = decode_html(html_entity_decode($adb->query_result($groupResults,0,'groupname'),ENT_QUOTES,$default_charset));
					}else{
						$user_name = decode_html(html_entity_decode($userRecordModel->get('first_name').' '.$userRecordModel->get('last_name'),ENT_QUOTES,$default_charset));
					}
					//$title = $user_name.' '.$this->CTTranslate('mentioned you');
					foreach ($mentioned_users as $key => $mentioned_user) {
						list($user_ws_id,$mentioned_user_id) = explode('x', $mentioned_user);
						$sub_perm_query = "SELECT * FROM ctmobile_notification_restriction WHERE user_id = ? AND notification_id = ?";
						$sub_perm_result = $adb->pquery($sub_perm_query,array($mentioned_user_id,$notification_id));
						if($adb->num_rows($sub_perm_result) == 0){
							$perm_qry = "SELECT devicetoken,device_type FROM ctmobile_userdevicetoken WHERE userid = ?";
							$perm_result = $adb->pquery($perm_qry, array($mentioned_user_id));
							$perm_rows = $adb->num_rows($perm_result);
							if($perm_rows > 0){
								$devicetoken = $adb->query_result($perm_result,0,'devicetoken');
								$device_type = $adb->query_result($perm_result,0,'device_type');
								if($devicetoken && $device_type){
									$module_Name = 'CTPushNotification';
									$relatedCRMid = substr($relatedTo, stripos($relatedTo, 'x')+1);
									$focus = CRMEntity::getInstance($module_Name);
									$focus->column_fields['description'] = $message;
									$focus->column_fields['assigned_user_id'] = $mentioned_user_id;
									$focus->column_fields['pn_related'] = $relatedCRMid;
									$focus->column_fields['pushnotificationstatus'] = 'Draft';
									$focus->column_fields['devicekey'] = $devicetoken;
									$focus->column_fields['pn_title'] =  $title;
									$focus->save($module_Name);
									if($focus->id != ''){
										$record_id = $focus->id;
										$result = CTMobileSettings_Module_Model::sendpushnotification($message,$devicetoken,$device_type,$title,'record',$relatedTo,CTMobile_WS_Utils::detectModulenameFromRecordId($relatedTo));
										if($result){
											$recordModel = Vtiger_Record_Model::getInstanceById($record_id, $module_Name);
											$modelData = $recordModel->getData();
											$recordModel->set('mode', 'edit');
											$recordModel->set('pushnotification_response', $result);
											$recordModel->set('pushnotificationstatus', 'Send');
											$recordModel->save();
										}
									} 
									
								}
							}
						}
					}
				}
			}
			//code end for notification of mentioned in comment
			if(!empty($id)){

				$record = explode('x',$id);
				$modcommentsid = $record[1];
				/*$adb->pquery("UPDATE vtiger_modcomments SET related_to = ? WHERE modcommentsid = ?",array($relatedCRMid,$modcommentsid));
				if($request->get('reasontoedit') != ''){
					$adb->pquery("UPDATE vtiger_modcomments SET reasontoedit = ? WHERE modcommentsid = ?",array($request->get('reasontoedit'),$modcommentsid));
				}*/
				$query = "SELECT vtiger_modcomments.*, vtiger_crmentity.createdtime,vtiger_crmentity.modifiedtime, vtiger_crmentity.smownerid from vtiger_modcomments INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_modcomments.modcommentsid where vtiger_crmentity.deleted = 0 and vtiger_modcomments.modcommentsid = ? ";

				$getCommentQuery = $adb->pquery($query, array($modcommentsid));
				$countComment = $adb->num_rows($getCommentQuery);

				$modcommentId = $adb->query_result($getCommentQuery, 0, 'modcommentsid');
				$commentcontent = $adb->query_result($getCommentQuery, 0, 'commentcontent');
				$reasontoedit = $adb->query_result($getCommentQuery,0,'reasontoedit');
				$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
				$commentcontent = html_entity_decode($commentcontent, ENT_QUOTES, $default_charset);
				$reasontoedit = html_entity_decode($reasontoedit, ENT_QUOTES, $default_charset);
				$relatedTo = $adb->query_result($getCommentQuery, 0, 'related_to');
				$filenames = $adb->query_result($getCommentQuery, 0, 'filename');
				if($filenames != '' && $filenames != '0'){
					$files = explode(',',$filenames);
				}else{
					$files = array();
				}
				$Attachments = array();
				foreach ($files as $key => $fileid) {
					$filename = "";
					$file_URL = "";
					$fileAccess =  true;
					$AccessMessage = "";
					if($fileid != '' && $fileid != 0){
						$fileDetails = CTMobile_WS_Utils::getAttachments($fileid,$modcommentId);
						$filename = $fileDetails['filename'];
						$file_URL = $fileDetails['file_URL'];
						$file_URL = $site_URL.'modules/CTMobile/api/ws/DownloadUrl.php?record='.$fileid;
						$ext = pathinfo($fileDetails['file_URL'], PATHINFO_EXTENSION);
					}
					$Attachments[] = array('filename'=>$filename,'file_URL'=>$file_URL,'fileAccess'=>$fileAccess,'AccessMessage'=>$AccessMessage,'extension'=>$ext);
				}
				$parent_comments = $adb->query_result($getCommentQuery, 0, 'parent_comments');
				$userId = $adb->query_result($getCommentQuery, 0, 'smownerid');
				$createdtime = $adb->query_result($getCommentQuery, 0, 'createdtime');
				$modifiedtime = $adb->query_result($getCommentQuery, 0, 'modifiedtime');
				$isModified = false;
				$modifiedText = "";
				if($createdtime != $modifiedtime){
					$isModified = true;
					$modifiedtime = Vtiger_Util_Helper::formatDateDiffInStrings($modifiedtime);
					$modifiedText = vtranslate('LBL_COMMENT','ModComments').' '.strtolower(vtranslate('LBL_MODIFIED','ModComments')).' '.$modifiedtime;
				}
				
				$commentedtime = Vtiger_Util_Helper::formatDateDiffInStrings($createdtime);
				if($userId) {
					$userRecordModel = Vtiger_Record_Model::getInstanceById($userId, 'Users');
					$firstname = $userRecordModel->get('first_name');
					$firstname = html_entity_decode($firstname, ENT_QUOTES, $default_charset);
					$lastname = $userRecordModel->get('last_name');
					$lastname = html_entity_decode($lastname, ENT_QUOTES, $default_charset);
					$userImage = CTMobile_WS_Utils::getUserImage($userId);
				}
				$isEdit = false;
				if(Users_Privileges_Model::isPermitted('ModComments', 'EditView')){
					if($userId == $current_user->id){
						$isEdit = true;
					}
				}

				$commentsWSid = CTMobile_WS_Utils::getEntityModuleWSId('ModComments');
				$modcommentsData = array('modcommentId'=>$commentsWSid.'x'.$modcommentId, 'commentcontent'=>$commentcontent, 'relatedTo' => $relatedTo,'parent_comments'=>$commentsWSid.'x'.$parent_comments,'reasontoedit'=>$reasontoedit, 'userid'=>$userId,'attachments'=>$Attachments,'userName'=>$firstname." ".$lastname,'userImage'=>$userImage, 'createdtime'=>$createdtime,'ModifiedTime'=>$commentedtime,'isEdit'=>$isEdit,'isModified'=>$isModified,'modifiedText'=>$modifiedText);
				$response = new CTMobile_API_Response();
				$response->setResult(array('record'=>$modcommentsData,'message'=>$this->CTTranslate('Comment saved successfully')));
			}else{
				$response = new CTMobile_API_Response();
				$response->setResult(array('record'=>array(),'message'=>$this->CTTranslate('Comment not saved')));
			}
		
		}else{
			$response = new CTMobile_API_Response();
			$message = $this->CTTranslate('Comment module is not active');
			$response->setError(403,$message);
		}
		return $response;
	}

	function uploadAndSaveFiles($files,$id){
		if (!empty($files)) {
            $docID = $id;
            global $adb,$site_URL,$root_directory;
            $current_user = $this->getActiveUser();
            $moduleName = 'ModComments';
            $storagePath = 'storage/';
            $year  = date('Y');
            $month = date('F');
            $day   = date('j');
            $week  = '';
            
			$date_var = date("Y-m-d H:i:s");
			
            if (!is_dir($root_directory.$storagePath . $year)) {
                mkdir($root_directory.$storagePath . $year);
                chmod($root_directory.$storagePath . $year, 0777);
            }

            if (!is_dir($root_directory.$storagePath . $year . "/" . $month)) {
                mkdir($root_directory.$storagePath . "$year/$month");
                chmod($root_directory.$storagePath . "$year/$month", 0777);
            }

            if ($day > 0 && $day <= 7){
                $week = 'week1';
            }elseif ($day > 7 && $day <= 14){
                $week = 'week2';
            }elseif ($day > 14 && $day <= 21){
                $week = 'week3';
            }elseif ($day > 21 && $day <= 28){
                $week = 'week4';
            }else{
                $week = 'week5'; 
            }
            
            if (!is_dir($root_directory.$storagePath . $year . "/" . $month . "/" . $week)) {
                mkdir($root_directory.$storagePath . "$year/$month/$week");
                chmod($root_directory.$storagePath . "$year/$month/$week", 0777);
            }
            $interior = $storagePath . $year . "/" . $month . "/" . $week . "/";
            $crm_id = $adb->getUniqueID("vtiger_crmentity");
            $upload_status = move_uploaded_file($files['tmp_name'],$interior.$crm_id.'_'. $files['name']);
            if($upload_status && $moduleName == 'ModComments'){
	            
	            $lastInsertedId = $adb->pquery("select attachmentsid from vtiger_attachments order by attachmentsid DESC limit 0,1");
	            $attachmentsid = $adb->query_result($lastInsertedId, 0, 'attachmentsid');
	            $query1 = $adb->pquery("insert into vtiger_crmentity (`crmid`,`setype`) VALUES(?,?)",array($crm_id,'ModComments Attachment'));
	            $query2 = $adb->pquery("insert into vtiger_attachments (`attachmentsid`,`name`,`type`,`path`) VALUES(?,?,?,?)",array($crm_id,$files['name'],$files['type'],$interior));
	            $grtLastInserted = $adb->pquery("select attachmentsid,subject from vtiger_attachments where attachmentsid > ".$attachmentsid);
	            $total = $adb->num_rows($grtLastInserted);
	            for ($i=0; $i < $total; $i++) { 
	                $grtAttachmentsId = $adb->query_result($grtLastInserted, $i, 'attachmentsid');
	                $subject = $adb->query_result($grtLastInserted, $i, 'subject');
	                $adb->pquery("insert into vtiger_seattachmentsrel (`crmid`,`attachmentsid`) VALUES(?,?)",array($docID,$grtAttachmentsId));
	            }
	            $adb->pquery("UPDATE vtiger_modcomments SET filename = '".$grtAttachmentsId."' where modcommentsid = ".$docID);
            } 
			return $crm_id;     
        }
	}
}
