 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_VcardFields_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_VcardFields.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTMobileSettings_VcardFields_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_VcardFields_Js.editInstance;
    }
},{
    updatedBlockSequence : {},    
    registerSelectModuleChange:function() {
        jQuery("#vcard_fields_settings").on("change","#vcard_module", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator();
            var searchModule=jQuery(this).val();
            var selectedFields=jQuery("#vcard_fields_settings").find("#vcardselectedFields");
            if(searchModule !='') {
                var params= {
                    "type": "POST",
                    "url": "index.php?module=CTMobileSettings&parent=Settings&view=VcardFieldsAjax&vcard_module="+searchModule,
                    "dataType":"html",
                    "data" : {}
                };
                AppConnector.request(params).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        selectedFields.html(data);
                        app.changeSelectElementView(selectedFields);
                        //register all select2 Elements
                        app.showSelect2ElementView(selectedFields.find('select.select2'));
                    }
                )
            }else {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                selectedFields.html('');
            }
        });
    },
    
    registerSaveSettings:function() {
        jQuery("#vcard_fields_settings").on("click",".btnSaveSettings", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator();
            form = jQuery(this).closest('form');
            var saveUrl = form.serializeFormData();
            AppConnector.request(saveUrl).then(
                function(data) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    var params = {
                       title : "Field Save Successfully",
                       text: 'Field Save Successfully',
                       animation: 'show',
                       type: 'info'
                    };
                    Vtiger_Helper_Js.showPnotify(params);
                }
            );
        });
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerSelectModuleChange();
        this.registerSaveSettings();  
    }
});

