 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_Language_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_Language_Js.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTMobileSettings_Language_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_Language_Js.editInstance;
    }
},{
    updatedBlockSequence : {},    
    registerSelectModuleChange:function() {
        jQuery("#ct_language_settings").on("change","#ct_language", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            var ct_language=jQuery(this).val();
            var ct_section=jQuery('[name="ct_section"]').val();
            var selectedFields=jQuery("#ct_language_settings").find("#selectedFields");
            if(ct_language !='' && ct_section !='') {
                var params= {
                    "type": "POST",
                    "module" : "CTMobileSettings",
                    "view" :"CTLanguageAjax",
                    "ctlanguage" : ct_language,
                    "ctlanguage_section":ct_section,
                };
                AppConnector.request(params).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        selectedFields.html(data);
                        app.changeSelectElementView(selectedFields);
                    }
                )
            }else {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                selectedFields.html('');
            }
        });

        jQuery("#ct_language_settings").on("change","#ct_section", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            var ct_section=jQuery(this).val();
            var ct_language=jQuery('[name="ct_language"]').val();
            var selectedFields=jQuery("#ct_language_settings").find("#selectedFields");
            if(ct_language !='' && ct_section !='') {
                var params= {
                    "type": "POST",
                    "module" : "CTMobileSettings",
                    "view" :"CTLanguageAjax",
                    "ctlanguage" : ct_language,
                    "ctlanguage_section":ct_section,
                };
                AppConnector.request(params).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        selectedFields.html(data);
                        app.changeSelectElementView(selectedFields);
                    }
                )
            }else {
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                selectedFields.html('');
            }
        });
    },

    registerSaveSettings:function() {
        jQuery("#ct_language_settings").on("click",".btnSaveSettings", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            form = jQuery(this).closest('form');
            var saveUrl = form.serializeFormData();
            AppConnector.request(saveUrl).then(
                function(data) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    var params = {
                       title : "Language Fields Save Successfully",
                       text: 'Language Field Save Successfully',
                       animation: 'show',
                       type: 'info'
                    };
                    Vtiger_Helper_Js.showPnotify(params);
                }
            );
        });
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerSelectModuleChange();
        this.registerSaveSettings(); 
    }
});

jQuery(document).ready(function () {
    var instance = new CTMobileSettings_Language_Js();
    instance.registerEvents();
});
