 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_APILogsSettings_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_APILogsSettings.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTMobileSettings_APILogsSettings_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_APILogsSettings_Js.editInstance;
    }
},{
    updatedBlockSequence : {},    
    registerCheckBoxChange:function() {
       
        if ( $('#apilogs_settings').find('[type="checkbox"]').bootstrapSwitch('state')) {
            $('#apilog_action').show();
        }else{
            $('#apilog_action').hide();
        }

        jQuery("input[type='checkbox']").bootstrapSwitch();

        jQuery('#allow_notification').on('switchChange.bootstrapSwitch',function(e){
            var currentElement = jQuery(e.currentTarget);
            if (currentElement.bootstrapSwitch('state')) {
              $('#apilogs_settings').find('[type="checkbox"]').bootstrapSwitch('state', true);
              $('#apilog_action').show();
              registerUpdateLogValue('1');

            }else{
              $('#apilogs_settings').find('[type="checkbox"]').bootstrapSwitch('state', false);
              $('#apilog_action').hide();
              registerUpdateLogValue('0');
            }
        });

    },
    
    registerAPILogAction : function(){
        $('#removeLogs').on('click',function(){
           var message = app.vtranslate('Are you sure want to clear API logs ?');
           Vtiger_Helper_Js.showConfirmationBox({'message' : message}).then(function(data) {
                var params = {
                    module: 'CTMobileSettings',
                    action: 'SaveAPILogsSettings',
                    mode: 'removeLogs',
                
                };
                var progressIndicatorElement = jQuery.progressIndicator({
                    'position' : 'html',
                    'blockInfo' : {
                        'enabled' : true
                    }
                });
                AppConnector.request(params).then(function(data) {
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    if(data.result['success']){
                        var msg = app.vtranslate('Logs Remove Successfully');
                        var params = {
                            title : app.vtranslate('JS_MESSAGE'),
                            text: msg,
                            animation: 'show',
                            type: 'success'
                        };
                        Vtiger_Helper_Js.showMessage(params);
                    }
                });  
            });
        });
        $('#downloadLogs').on('click',function(){
            var params = {
                module: 'CTMobileSettings',
                action: 'SaveAPILogsSettings',
                mode: 'checkLogData',
            
            };
             var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });
            AppConnector.request(params).then(function(data) {
                console.log(data);
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                if(data.result['success'] > 0){
                    $('#downloadForm').submit();
                }else{
                    var msg = app.vtranslate('No Data Available.');
                    var params = {
                        title : app.vtranslate('JS_MESSAGE'),
                        text: msg,
                        animation: 'show',
                        type: 'success'
                    };
                    Vtiger_Helper_Js.showMessage(params);   
                }
            
            });  
            
        });
    },

  
    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerCheckBoxChange();
        this.registerAPILogAction(); 
    }
});

function registerUpdateLogValue(value){
        //alert(value);
    var params = {
        module: 'CTMobileSettings',
        action: 'SaveAPILogsSettings',
        mode: 'updateLogs',
        logvalue: value
    };
    var progressIndicatorElement = jQuery.progressIndicator({
                'position' : 'html',
                'blockInfo' : {
                    'enabled' : true
                }
            });
    AppConnector.request(params).then(function(data) {
        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
    });
}




