{*<!--
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
-->*}

{literal}
<style type="text/css">
.nav-tabs > li.active > a, .nav-tabs > li.active > a:hover, .nav-tabs > li.active > a:focus {
    color: #333;
    border-bottom: 3px solid #555;
}
</style>
{/literal}

<div class="container-fluid">
    <div class="widget_header row-fluid">
        <a class="btn btn-info pull-right" href="{CTMobileSettings_Module_Model::$CTMOBILE_DETAILVIEW_URL}"><img src="layouts/vlayout/skins/alphagrey/images/home.png" alt="Home" title="Home"></a>
        <h3>{vtranslate('CRMTiger Mobile Apps - Route General Configuration', 'CTMobileSettings')}</h3>
    </div>
    <hr>
   
    <div class="clearfix"></div>
    <div class="tab-content massEditContent">
              <ul class="nav nav-tabs massEditTabs">
                 <li class="active">
                      <a href="#routegeneral" data-toggle="tab" >
                          <strong>
                              {vtranslate('Route General', 'CTMobileSettings')}
                          </strong>
                      </a>
                  </li>
                  <li >
                      <a href="#routestatus" data-toggle="tab">
                          <strong>
                              {vtranslate('Route Status', 'CTMobileSettings')}
                          </strong>
                      </a>
                  </li>   
              </ul>

        <div class="tab-content massEditContent">
            <div class="tab-pane active" id="routegeneral">
                <h5 style="margin-left:20px;">{vtranslate('Add/Remove users from list to access of route planning','CTMobileSettings')}</h5>
                <div class="summaryWidgetContainer" id="route_distance_unit_settings">
                    <div class="row-fluid">
                        
                        <div class="select-search" style="margin-top:15px;">
                            <select class="select2" multiple="true" id="route_users" name="route_users[]" data-placeholder="Select Users" style="width: 800px">
                                {foreach key=FIELD_NAME item=FIELD_MODEL from=$USER_MODEL}
                                    <option value="{$FIELD_MODEL['userid']}" data-field-name="{$FIELD_MODEL['username']}"
                                             {if in_array($FIELD_MODEL['userid'], $ROUTE_USERS)}
                                               selected
                                             {/if}
                                            >{$FIELD_MODEL['username']}
                                    </option>
                                {/foreach}
                            </select>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div style="margin-top:15px;">
                            {vtranslate('Select Distance Unit',$MODULE)}
                        </div>
                        <div class="select-search" style="margin-top:15px;">
                            <select class="select2" id="distanceUnit" name="distanceUnit" data-placeholder="{vtranslate('Select Distance Unit',$MODULE)}" style="width: 300px">
                               <option value="Kilometers" {if $DISTANCE_UNIT eq 'Kilometers'} selected {/if}>{vtranslate('Kilometers',$MODULE)}</option>
                               <option value="Miles" {if $DISTANCE_UNIT eq 'Miles'} selected {/if}>{vtranslate('Miles',$MODULE)}</option>
                            </select>
                        </div>
                    </div>
                    <br/>
                    <div class="row-fluid">
                        <button class="btn btn-success btnSaveDistanceUnit" type="button">{vtranslate('LBL_SAVE', 'CTMobileSettings')}</button>
                        <a class="cancelLink" type="reset" onclick="javascript:window.history.back();">{vtranslate('Cancel','CTMobileSettings')}</a>
                    </div>  
                </div>
            </div>

            <div class="tab-pane" id="routestatus" style="">
                <div class="summaryWidgetContainer" id="route_status_settings">
                    <form action="index.php" method="post" id="Settings" class="form-horizontal">
                    <input type="hidden" name="module" value="CTMobileSettings">
                    <input type="hidden" name="action" value="SaveRouteGeneralSettings">
                    <input type="hidden" name="mode" value="SaveStatus">
                        <div class="row-fluid">
                            <table class="table table-bordered blockContainer showInlineTable equalSplit">
                                {foreach from=$ROUTE_STATUS key=key item=STATUS}
                                    <tr>
                                        <td class="fieldLabel alignMiddle">
                                            {$STATUS['routestatusname']}
                                        </td>
                                        <td class="fieldValue">
                                            <input class="inputElement" type="text" name="status_{$STATUS['routestatusid']}" value="{$STATUS['routestatuslabel']}">
                                        </td>
                                    </tr>
                                {/foreach}
                            </table>
                        </div>
                        <br/>
                        <div class="row-fluid">
                            <button class="btn btn-success btnSaveStatus" type="button">{vtranslate('LBL_SAVE', 'CTMobileSettings')}</button>
                            <a class="cancelLink" type="reset" onclick="javascript:window.history.back();">{vtranslate('Cancel','CTMobileSettings')}</a>
                        </div> 
                    </form>
                </div> 
            </div>
        </div>
    
</div>

