 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_NotificationSettings_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_NotificationSettings.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTMobileSettings_NotificationSettings_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_NotificationSettings_Js.editInstance;
    }
},{
    updatedBlockSequence : {},    
    registerCheckBoxChange:function() {
        form = jQuery("#notification_settings").find('#notification_settings_form');
        jQuery("input[type='checkbox']").bootstrapSwitch();

        jQuery('#allow_notification').on('switchChange.bootstrapSwitch',function(e){
            var currentElement = jQuery(e.currentTarget);
            if (currentElement.bootstrapSwitch('state')) {
              form.find('[type="checkbox"]').bootstrapSwitch('state', true);
            }else{
              form.find('[type="checkbox"]').bootstrapSwitch('state', false);
            }
        });

        jQuery(form).on('switchChange.bootstrapSwitch', "input[type='checkbox']", function (e) {
            var currentElement = jQuery(e.currentTarget);
            if(currentElement.bootstrapSwitch('state')){
                currentElement.attr('value','1');
            } else {
                currentElement.attr('value','0');
            }
        });

    },
    
    registerSaveSettings:function() {

         jQuery("#notification_settings").on("click",".btnSaveSettings", function(e) {

            form = jQuery("#notification_settings").find('#notification_settings_form');
            var saveUrl = form.serializeFormData();
            var record_assigned = saveUrl.record_assigned;
            var record_assigned_module = jQuery('#record_assigned_module').val();
            
            var comment_assigned = saveUrl.comment_assigned;
            var comment_assigned_module = jQuery('#comment_assigned_module').val();

            var follow_record = saveUrl.follow_record;
            var follow_record_module = jQuery('#follow_record_module').val();

            if(record_assigned == '1' && record_assigned_module == null){
                app.helper.showErrorNotification({message:"Select atleast one Module for Record Assigned"}); 
                return false; 
            }else if(comment_assigned == '1' && comment_assigned_module == null){
                app.helper.showErrorNotification({message:"Select atleast one module for Comment on Assigned Record"}); 
                return false; 
            }else if(follow_record == '1' && follow_record_module == null){
                app.helper.showErrorNotification({message:"Select atleast one module for Follow Record"}); 
                return false; 
            }else{
                var progressIndicatorElement = jQuery.progressIndicator({
                  'position' : 'html',
                  'blockInfo' : {
                   'enabled' : true
                  }
                });
                AppConnector.request(saveUrl).then(
                    function(data) {
                        progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                        var params = {
                           title : "Notification Settings Save Successfully",
                           text: 'Notification Settings Save Successfully',
                           animation: 'show',
                           type: 'info'
                        };
                        Vtiger_Helper_Js.showPnotify(params);
                    }
                );
            }
        });
        
    },

    
    registerAppTriggerEvent : function() {
        jQuery('.app-menu').removeClass('hide');
        var toggleAppMenu = function(type) {
            var appMenu = jQuery('.app-menu');
            var appNav = jQuery('.app-nav');
            appMenu.appendTo('#page');
            appMenu.css({
                'top' : appNav.offset().top + appNav.height(),
                'left' : 0
            });
            if(typeof type === 'undefined') {
                type = appMenu.is(':hidden') ? 'show' : 'hide';
            }
            if(type == 'show') {
                appMenu.show(200, function() {});
            } else {
                appMenu.hide(200, function() {});
            }
        };

        jQuery('.app-trigger, .app-icon, .app-navigator').on('click',function(e){
            e.stopPropagation();
            toggleAppMenu();
        });

        jQuery('html').on('click', function() {
            toggleAppMenu('hide');
        });

        jQuery(document).keyup(function (e) {
            if (e.keyCode == 27) {
                if(!jQuery('.app-menu').is(':hidden')) {
                    toggleAppMenu('hide');
                }
            }
        });

        jQuery('.app-modules-dropdown-container').hover(function(e) {
            var dropdownContainer = jQuery(e.currentTarget);
            jQuery('.dropdown').removeClass('open');
            if(dropdownContainer.length) {
                if(dropdownContainer.hasClass('dropdown-compact')) {
                    dropdownContainer.find('.app-modules-dropdown').css('top', dropdownContainer.position().top - 8);
                } else {
                    dropdownContainer.find('.app-modules-dropdown').css('top', '');
                }
                dropdownContainer.addClass('open').find('.app-item').addClass('active-app-item');
            }
        }, function(e) {
            var dropdownContainer = jQuery(e.currentTarget);
            dropdownContainer.find('.app-item').removeClass('active-app-item');
            setTimeout(function() {
                if(dropdownContainer.find('.app-modules-dropdown').length && !dropdownContainer.find('.app-modules-dropdown').is(':hover') && !dropdownContainer.is(':hover')) {
                    dropdownContainer.removeClass('open');
                }
            }, 500);

        });

        jQuery('.app-item').on('click', function() {
            var url = jQuery(this).data('defaultUrl');
            if(url) {
                window.location.href = url;
            }
        });

        jQuery(window).resize(function() {
            jQuery(".app-modules-dropdown").mCustomScrollbar("destroy");
            app.helper.showVerticalScroll(jQuery(".app-modules-dropdown").not('.dropdown-modules-compact'), {
                setHeight: $(window).height(),
                autoExpandScrollbar: true
            });
            jQuery('.dropdown-modules-compact').each(function() {
                var element = jQuery(this);
                var heightPer = parseFloat(element.data('height'));
                app.helper.showVerticalScroll(element, {
                    setHeight: $(window).height()*heightPer - 3,
                    autoExpandScrollbar: true,
                    scrollbarPosition: 'outside'
                });
            });
        });
        app.helper.showVerticalScroll(jQuery(".app-modules-dropdown").not('.dropdown-modules-compact'), {
            setHeight: $(window).height(),
            autoExpandScrollbar: true,
            scrollbarPosition: 'outside'
        });
        jQuery('.dropdown-modules-compact').each(function() {
            var element = jQuery(this);
            var heightPer = parseFloat(element.data('height'));
            app.helper.showVerticalScroll(element, {
                setHeight: $(window).height()*heightPer - 3,
                autoExpandScrollbar: true,
                scrollbarPosition: 'outside'
            });
        });
    },

    registerEventsforShowHide : function(){
        form = jQuery("#notification_settings").find('#notification_settings_form');
        if(form.find('[name="comment_assigned"]').bootstrapSwitch('state') == true){
            var div = 'comment_assigned_div';
            jQuery('#'+div).show();
        }else{
            var div = 'comment_assigned_div';
            jQuery('#'+div).hide();
        }

        if(form.find('[name="record_assigned"]').bootstrapSwitch('state') == true){
            var div = 'record_assigned_div';
            jQuery('#'+div).show();
        }else{
            var div = 'record_assigned_div';
            jQuery('#'+div).hide();
        }

        if(form.find('[name="follow_record"]').bootstrapSwitch('state') == true){
            var div = 'follow_record_div';
            jQuery('#'+div).show();
        }else{
            var div = 'follow_record_div';
            jQuery('#'+div).hide();
        }

        jQuery(form).on('switchChange.bootstrapSwitch', "input[name='comment_assigned']", function (e) {
            var currentElement = jQuery(e.currentTarget);
            var div = 'comment_assigned_div';
            if(currentElement.bootstrapSwitch('state')){
              jQuery('#'+div).show();
            }else{
              jQuery('#'+div).hide();
            }
        });
        jQuery(form).on('switchChange.bootstrapSwitch', "input[name='record_assigned']", function (e) {
            var currentElement = jQuery(e.currentTarget);
            var div = 'record_assigned_div';
            if(currentElement.bootstrapSwitch('state')){
              jQuery('#'+div).show();
            }else{
              jQuery('#'+div).hide();
            }
        });

        jQuery(form).on('switchChange.bootstrapSwitch', "input[name='follow_record']", function (e) {
            var currentElement = jQuery(e.currentTarget);
            var div = 'follow_record_div';
            if(currentElement.bootstrapSwitch('state')){
              jQuery('#'+div).show();
            }else{
              jQuery('#'+div).hide();
            }
        });
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerCheckBoxChange();
        this.registerSaveSettings(); 
        this.registerAppTriggerEvent();
        this.registerEventsforShowHide(); 
    }
});


jQuery(document).ready(function () {
    var instance = new CTMobileSettings_NotificationSettings_Js();
    instance.registerEvents();
});

