/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
$(document).ready(function(){

	function getParameterByName(name, url) {
	    if (!url) url = window.location.href;
	    name = name.replace(/[\[\]]/g, "\\$&");
	    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
	        results = regex.exec(url);
	    if (!results) return null;
	    if (!results[2]) return '';
	    return decodeURIComponent(results[2].replace(/\+/g, " "));
	}
	

	var record = getParameterByName('record') || '';
	$.is_new_account = false;
	if(record == ''){
		$.is_new_account = true;
		console.log("Buscar documento duplicado", record);
		$("input[name='siccode']").blur(function(){
			validarRuc();
		});
	}

	validarRuc = function(){
		var ruc = $("input[name='siccode']").val() || '';
		var tipo_doc = $("select[name='cf_751']").val() || '';
		
		if ( ruc.trim() != "" && tipo_doc != "" ) {
			$.ajax({
				url: 'ConsultasAjax.php',
				data: {
				 'accion' : 'verificarDuplicidadRuc', 
				 'ruc': ruc, 
				 'tipo_doc' : tipo_doc
				},
				success: function(data){
					if(parseInt(data) > 0){
						var message = "El " +tipo_doc+ " número: " +ruc+ " ya existe. Por favor verifique";
						Vtiger_Helper_Js.showMessage(message);
						$("input[name='siccode']").focus();
						$('#Accounts_editView_fieldName_siccode').val('');
					}
				}
			});
		}
		
	};
});

Vtiger_Edit_Js("Accounts_Edit_Js",{
   
},{
   
    //Stored history of account name and duplicate check result
	duplicateCheckCache : {},
	
	//This will store the editview form
	editViewForm : false,
   
	//Address field mapping within module
	addressFieldsMappingInModule : {
										'bill_street':'ship_street',
										'bill_pobox':'ship_pobox',
										'bill_city'	:'ship_city',
										'bill_state':'ship_state',
										'bill_code'	:'ship_code',
										'bill_country':'ship_country'
								},
   
   // mapping address fields of MemberOf field in the module              
   memberOfAddressFieldsMapping : {
                                        'bill_street':'bill_street',
										'bill_pobox':'bill_pobox',
										'bill_city'	:'bill_city',
										'bill_state':'bill_state',
										'bill_code'	:'bill_code',
										'bill_country':'bill_country',
                                        'ship_street' : 'ship_street',        
                                        'ship_pobox' : 'ship_pobox',
                                        'ship_city':'ship_city',
                                        'ship_state':'ship_state',
                                        'ship_code':'ship_code',
                                        'ship_country':'ship_country'
                                   },                          
								
	/**
	 * This function will return the current form
	 */
	getForm : function(){
		if(this.editViewForm == false) {
			this.editViewForm = jQuery('#EditView');
		}
		return this.editViewForm;
	},
        
	/**
	 * This function will return the account name
	 */
	getAccountName : function(container){
		return jQuery('input[name="accountname"]',container).val();
	},
        
	/**
	 * This function will return the current RecordId
	 */
	getRecordId : function(container){
		return jQuery('input[name="record"]',container).val();
	},
       
	/**
	 * This function will register before saving any record
	 */
	registerRecordPreSaveEvent : function(form) {
		var thisInstance = this;
		if(typeof form == 'undefined') {
			form = this.getForm();
		}
		
		form.on(Vtiger_Edit_Js.recordPreSave, function(e, data) {
			var accountName = thisInstance.getAccountName(form);
			var recordId = thisInstance.getRecordId(form);
			var params = {};
            console.log("registerRecordPreSaveEvent");
			//------------------------- guarda
            if(!(accountName in thisInstance.duplicateCheckCache)) {
                Vtiger_Helper_Js.checkDuplicateName({
                    'accountName' : accountName, 
                    'recordId' : recordId,
                    'moduleName' : 'Accounts'
                }).then(
                    function(data){
                        validaDatosCuenta( data['success'] );
                    },
                    function(data, err){
                        thisInstance.duplicateCheckCache[accountName] = data['success'];
                        thisInstance.duplicateCheckCache['message'] = data['message'];
						var message = app.vtranslate('JS_DUPLICTAE_CREATION_CONFIRMATION');
						Vtiger_Helper_Js.showConfirmationBox({'message' : message}).then(
							function(e) {
								//thisInstance.duplicateCheckCache[accountName] = false;
								//form.submit();
								validaDatosCuenta( false );
							},
							function(error, err) {
								
							}
						);
                    }
				);
            }
           
			else {
				if(thisInstance.duplicateCheckCache[accountName] == true){
					var message = app.vtranslate('JS_DUPLICTAE_CREATION_CONFIRMATION');
					Vtiger_Helper_Js.showConfirmationBox({'message' : message}).then(
						function(e) {
							//thisInstance.duplicateCheckCache[accountName] = false;
							//form.submit();
							validaDatosCuenta( false );
						},
						function(error, err) {
							
						}
					);
				} else {
					delete thisInstance.duplicateCheckCache[accountName];
					return true;
				}
			}

			function validaDatosCuenta( value_check ){
				var accounttype = $("select[name='accounttype']");
				if ( (accounttype.val() == 'Cliente' && $.account_is_change) || (accounttype.val() == 'Cliente' && $.is_new_account) ) {
					var razon_social = $("input[name='accountname']").val();
					var ruc = $("input[name='siccode']").val();
					var direccion = $("textarea[name='ship_street']").val();
					var email_fac_elect = $("input[name='email1']").val();
					var tipo_doc = $("select[name='cf_751']").val();
					var message = "<table>";
					message += "<tr>";
					message += "<td colspan='2' align='center'><h2>Confirmar datos para Sincronización con ERP<h2></td>";
					message += "</tr>";
					message += "<tr>";
					message += "<td><b>Razón Social:</b></td><td>" + razon_social + "</td>";
					message += "</tr>";
					message += "<tr>";
					message += "<td><b>"+tipo_doc+":</b></td><td>" + ruc + "</td>";
					message += "</tr>";
					message += "<tr>";
					message += "<td><b>Email:</b></td><td>" + email_fac_elect + "</td>";
					message += "</tr>";
					message += "<tr>";
					message += "<td><b>Dirección Comercial: </b></td><td>" + direccion + "</td>";
					message += "</tr>";
					message += "</table>";
					Vtiger_Helper_Js.showConfirmationBox({'message' : message}).then(
						function(e) {
							console.log("SI validados");
							$("#flg_datos_validados").prop("checked", true);
							$("#flg_datos_validados").val(1);
							thisInstance.duplicateCheckCache[accountName] = value_check;
                    		form.submit();
						},
						function(error, err) {
							$("#flg_datos_validados").prop("checked", false);
							$("#flg_datos_validados").val(0);
							console.log("NO validados");
							console.log("error: ", error, err);
							e.preventDefault();
							return false;
						}
					);
					console.log("flg_datos_validados: ", $("#flg_datos_validados").prop("checked"));
					console.log("duplicateCheckCache: ", thisInstance.duplicateCheckCache[accountName]);
				} else {
					thisInstance.duplicateCheckCache[accountName] = value_check;
                    form.submit();
				}
			}

			function validaRucExistente(){
				var siccode = $("input[name='siccode']").val();
			}

            e.preventDefault();
            //------------------------- guarda
		})
	},
	
	/**
	 * Function to swap array
	 * @param Array that need to be swapped
	 */ 
	swapObject : function(objectToSwap){
		var swappedArray = {};
		var newKey,newValue;
		for(var key in objectToSwap){
			newKey = objectToSwap[key];
			newValue = key;
			swappedArray[newKey] = newValue;
		}
		return swappedArray;
	},
	
	/**
	 * Function to copy address between fields
	 * @param strings which accepts value as either odd or even
	 */
	copyAddress : function(swapMode, container){
		var thisInstance = this;
		var addressMapping = this.addressFieldsMappingInModule;
		if(swapMode == "false"){
			for(var key in addressMapping) {
				var fromElement = container.find('[name="'+key+'"]');
				var toElement = container.find('[name="'+addressMapping[key]+'"]');
				toElement.val(fromElement.val());
			}
		} else if(swapMode){
			var swappedArray = thisInstance.swapObject(addressMapping);
			for(var key in swappedArray) {
				var fromElement = container.find('[name="'+key+'"]');
				var toElement = container.find('[name="'+swappedArray[key]+'"]');
				toElement.val(fromElement.val());
			}
		}
	},
	
	/**
	 * Function to register event for copying address between two fileds
	 */
	registerEventForCopyingAddress : function(container){
		var thisInstance = this;
		var swapMode;
		jQuery('[name="copyAddress"]').on('click',function(e){
			var element = jQuery(e.currentTarget);
			var target = element.data('target');
			if(target == "billing"){
				swapMode = "false";
			}else if(target == "shipping"){
				swapMode = "true";
			}
			thisInstance.copyAddress(swapMode, container);
		})
	},
	
	/**
	 * Function which will register event for Reference Fields Selection
	 */
	registerReferenceSelectionEvent : function(container) {
		var thisInstance = this;
		
		jQuery('input[name="account_id"]', container).on(Vtiger_Edit_Js.referenceSelectionEvent, function(e, data){
			thisInstance.referenceSelectionEventHandler(data, container);
		});
	},
	
	/**
	 * Reference Fields Selection Event Handler
	 * On Confirmation It will copy the address details
	 */
	referenceSelectionEventHandler :  function(data, container) {
		var thisInstance = this;
		var message = app.vtranslate('OVERWRITE_EXISTING_MSG1')+app.vtranslate('SINGLE_'+data['source_module'])+' ('+data['selectedName']+') '+app.vtranslate('OVERWRITE_EXISTING_MSG2');
		Vtiger_Helper_Js.showConfirmationBox({'message' : message}).then(
			function(e) {
				thisInstance.copyAddressDetails(data, container);
			},
			function(error, err){
			});
	},
	
	/**
	 * Function which will copy the address details - without Confirmation
	 */
	copyAddressDetails : function(data, container) {
		var thisInstance = this;
		thisInstance.getRecordDetails(data).then(
			function(data){
				var response = data['result'];
				thisInstance.mapAddressDetails(thisInstance.memberOfAddressFieldsMapping, response['data'], container);
			},
			function(error, err){

			});
	},
	
	/**
	 * Function which will map the address details of the selected record
	 */
	mapAddressDetails : function(addressDetails, result, container) {
		for(var key in addressDetails) {
			// While Quick Creat we don't have address fields, we should  add
            if(container.find('[name="'+key+'"]').length == 0) { 
                   container.append("<input type='hidden' name='"+key+"'>"); 
            } 
			container.find('[name="'+key+'"]').val(result[addressDetails[key]]);
			container.find('[name="'+key+'"]').trigger('change');
			container.find('[name="'+addressDetails[key]+'"]').val(result[addressDetails[key]]);
			container.find('[name="'+addressDetails[key]+'"]').trigger('change');
		}
	},
	//--------------------------------------- henry --------------------------------------
	initForm : function(){
		$("#Accounts_editView_fieldName_cf_801").attr("readonly", true);
		$("#Accounts_editView_fieldName_bill_pobox").attr("readonly", true);
		$("#Accounts_editView_fieldName_bill_state").attr("readonly", true);
		$("#Accounts_editView_fieldName_bill_city").attr("readonly", true);
	},
	changeComoLlegoFursys : function() {
		$("select[name='cf_799']").change(function(){
			if ($(this).val() == 'Otro') {
				$("#Accounts_editView_fieldName_cf_801").attr("readonly", false);
				$("#Accounts_editView_fieldName_cf_801").attr("data-validation-engine","validate[required,funcCall[Vtiger_Base_Validator_Js.invokeValidation]]");
			} else {
				$("#Accounts_editView_fieldName_cf_801").attr("readonly", true);
				$("#Accounts_editView_fieldName_cf_801").attr("data-validation-engine","validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]");
			}
		});
		$("select[name='cf_799']").trigger("change");
	},
	blurNombre : function(){
    	var nombre = $("input[name='cf_885']");
    	nombre.blur(function(){
    		var apellido_pat = $("input[name='cf_881']").val();
    		var apellido_mat = $("input[name='cf_883']").val();
    		$("input[name='accountname']").val(nombre.val()+' '+apellido_pat + ' ' + apellido_mat);

    	})
    },
    blurApellidos : function(){
    	var apellido_pat = $("input[name='cf_881']");
    	var apellido_mat = $("input[name='cf_883']");
    	apellido_pat.blur(function(){
    		var nombre = $("input[name='cf_885']").val();
    		$("input[name='accountname']").val(nombre + ' '+apellido_pat.val() + ' ' + apellido_mat.val());
    	});
    	apellido_mat.blur(function(){
    		var nombre = $("input[name='cf_885']").val();
    		$("input[name='accountname']").val(nombre + ' '+apellido_pat.val() + ' ' + apellido_mat.val());
    	});
    },
	cambioPersona : function(){
    	var nombre = $("input[name='cf_885']").val();
    	var apellido_pat = $("input[name='cf_881']").val();
    	var apellido_mat = $("input[name='cf_883']").val();
    	
    	$("select[name='cf_887']").change(function (){
    		console.log("persona change");
    		var persona = $("select[name='cf_887']");
    		var html_view = '<td class="fieldLabel medium temp_td">';
	    	if(persona.val()!='Natural'){
	    		$("input[name='accountname']").removeAttr('readonly');
	    		//$("input[name='accountname']").val('');
				$("input[name='cf_885']").parent().parent().parent().hide();//nombre
				$("input[name='cf_885']").parent().parent().parent().prev().hide();// label nombre
				$("input[name='cf_881']").parent().parent().parent().hide(); //paterno
				$("input[name='cf_881']").parent().parent().parent().prev().hide(); //label paterno
				$("input[name='cf_883']").parent().parent().parent().hide(); //materno
				$("input[name='cf_883']").parent().parent().parent().prev().hide(); //label materno
				$("input[name='cf_883']").parent().parent().parent().parent().append(html_view + html_view);

				$("input[name='cf_885']").attr('data-validation-engine','validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("input[name='cf_881']").attr('data-validation-engine','validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("input[name='cf_883']").attr('data-validation-engine','validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
			}
			else{
				$("input[name='accountname']").prop('readonly','true');
				//$("input[name='accountname']").val('');
				$("input[name='cf_885']").parent().parent().parent().show();//nombre
				$("input[name='cf_885']").parent().parent().parent().prev().show();// label nombre
				$("input[name='cf_881']").parent().parent().parent().show(); //paterno
				$("input[name='cf_881']").parent().parent().parent().prev().show(); //label paterno
				$("input[name='cf_883']").parent().parent().parent().show(); //materno
				$("input[name='cf_883']").parent().parent().parent().prev().show(); //label materno
				$(".temp_td").remove();

				$("input[name='cf_885']").attr('data-validation-engine','validate[required,funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("input[name='cf_881']").attr('data-validation-engine','validate[required,funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("input[name='cf_883']").attr('data-validation-engine','validate[required,funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
			}
    	});
    	
    	$("select[name='cf_887']").trigger('change'); // Tipo de Persona

    	$("#Accounts_editView_fieldName_cf_845_clear").click(function(){
    		$("input[name='bill_city']").val("");
	    	$("input[name='bill_state']").val("");
	    	$("input[name='bill_pobox']").val("");
	    	$("input[name='bill_country']").val("");
    	});
    },
    changeAccounttype : function(){
    	form = this.getForm()
    	form.append("<input type='checkbox' name='cf_889' id='flg_datos_validados' style='display:none;' >");
    	
		$("select[name='accounttype']").change(function(){
			var accounttype = $("select[name='accounttype']");
			console.log("accounttype", accounttype.val());
			if (accounttype.val() == 'Cliente') {
				$("textarea[name='bill_street']").attr('data-validation-engine','validate[required,funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("textarea[name='ship_street']").attr('data-validation-engine','validate[required,funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("input[name='siccode']").attr('data-validation-engine','validate[required,funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("select[name='cf_751']").attr('data-validation-engine','validate[required,funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("#cf_845_display").attr('data-validation-engine','validate[required,funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("input[name='email1']").attr('data-validation-engine','validate[required,funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
			} else {
				$("textarea[name='bill_street']").attr('data-validation-engine','validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("textarea[name='ship_street']").attr('data-validation-engine','validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("input[name='siccode']").attr('data-validation-engine','validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("select[name='cf_751']").attr('data-validation-engine','validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("#cf_845_display").attr('data-validation-engine','validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
				$("input[name='email1']").attr('data-validation-engine','validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]');
			}
		});
    	
    	$("select[name='accounttype']").trigger('change');
    },
    verificarCambioCuenta : function(){
    	$.account_is_change = false;
		var record = this.getParameterByName('record') || '';
		if (record != '') {
			$("select[name='cf_887']").change(function(){
				console.log('cf_887');
				verificar();
			});
			$("input[name='siccode']").blur(function(){
				console.log('siccode');
				verificar();
			});
			$("select[name='cf_751']").change(function(){
				console.log('cf_751');
				verificar();
			});
			$("input[name='accountname']").blur(function(){
				console.log('accountname');
				verificar();
			});
			$("input[name='cf_881']").blur(function(){
				console.log('cf_881');
				verificar();
			});
			$("input[name='cf_883']").blur(function(){
				console.log('cf_883');
				verificar();
			});
			$("input[name='cf_885']").blur(function(){
				console.log('cf_885');
				verificar();
			});
			$("input[name='email1']").blur(function(){
				console.log('email1');
				verificar();
			});
			$("textarea[name='ship_street']").blur(function(){
				console.log('ship_street');
				verificar();
			});
			$("input[name='cf_843']").blur(function(){
				console.log('cf_843');
				verificar();
			});
		}

		function verificar(){
			var data = {
				'accion'			: 'verificaCambioCuenta',
				'accountid'			: record,
				'tipo_persona'		: $("select[name='cf_887']").val(),
				'nro_documento'		: $("input[name='siccode']").val(),
				'tipo_documento'	: $("select[name='cf_751']").val(),
				'razon_social'		: $("input[name='accountname']").val(),
				'app_paterno'		: $("input[name='cf_881']").val(),
				'app_materno'		: $("input[name='cf_883']").val(),
				'nombres'			: $("input[name='cf_885']").val(),
				'email_fac_elect'	: $("input[name='email1']").val(),
				'direccion_comer'	: $("textarea[name='ship_street']").val(),
				'num_ubigeo'		: $("input[name='cf_843']").val(),
			};
			
			$.ajax({
				url: 'ConsultasAjax.php',
				data: data,
				success: function(response){
					console.log(response);
					var response = JSON.parse(response);
					if( response != null ){
						$.account_is_change = response.is_change;
					}
				}
			});
		}
	},
	getParameterByName : function(name, url) {
	    if (!url) url = window.location.href;
	    name = name.replace(/[\[\]]/g, "\\$&");
	    var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
	        results = regex.exec(url);
	    if (!results) return null;
	    if (!results[2]) return '';
	    return decodeURIComponent(results[2].replace(/\+/g, " "));
	},
	//--------------------------------------- henry --------------------------------------
	
	/**
	 * Function which will register basic events which will be used in quick create as well
	 *
	 */
	registerBasicEvents : function(container) {
		this._super(container);
		this.registerRecordPreSaveEvent(container);
		this.registerEventForCopyingAddress(container);
		this.registerReferenceSelectionEvent(container);
		this.changeComoLlegoFursys();
		this.initForm();
		this.cambioPersona();
		this.changeAccounttype();
		this.blurNombre();
		this.blurApellidos();
		this.verificarCambioCuenta();
			//container.trigger(Vtiger_Edit_Js.recordPreSave, {'value': 'edit'});
		//--Henry:
		// $("#Accounts_editView_fieldName_cf_855").attr("disabled",true);
	}
});