 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_RouteGeneralSettings_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_RouteGeneralSettings_Js.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTMobileSettings_RouteGeneralSettings_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_RouteGeneralSettings_Js.editInstance;
    }
},{ 
    registerSaveSettings:function() {
        jQuery(".btnSaveDistanceUnit").on("click", function(e) {
            var distanceUnit = jQuery('#distanceUnit').val();
            var route_users = jQuery('#route_users').val();
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
             });
            var params= {
                "module" : "CTMobileSettings",
                "action" :"SaveRouteGeneralSettings",
                "distanceUnit" : distanceUnit,
                "route_users"  : route_users
            };
            AppConnector.request(params).then(function(data){
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                var params = {
                   title : app.vtranslate('Route General Settings Save Successfully'),
                   text: app.vtranslate("Route General Settings Save Successfully"),
                   animation: 'show',
                   type: 'info'
                };
                Vtiger_Helper_Js.showPnotify(params);
            });
        });

        jQuery(".btnSaveStatus").on("click", function(e) {
            var progressIndicatorElement = jQuery.progressIndicator({
              'position' : 'html',
              'blockInfo' : {
               'enabled' : true
              }
            });
            form = jQuery(this).closest('form');
            var saveUrl = form.serializeFormData();

            AppConnector.request(saveUrl).then(function(data){
                progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                var params = {
                   title : app.vtranslate('Route Status Settings Save Successfully'),
                   text: app.vtranslate("Route Status Settings Save Successfully"),
                   animation: 'show',
                   type: 'info'
                };
                Vtiger_Helper_Js.showPnotify(params);
            });
        });
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        this.registerSaveSettings(); 
    }
});


