{*<!--
/*********************************************************************************
** The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
*
 ********************************************************************************/
-->*}

{literal}
<style>
.ctlefthideessentials-toggle,.ctleftshowessentials-toggle{
 	background-color: white;
    font-weight: bold;
    padding: 5px 2px !important;
    position: absolute;
    top: 0px !important;
    left: 45%;
    cursor: pointer;
    width: 14px;
    border: 1px solid #DDDDDD;
    /*border-left: 0;*/
    display: inline-block;
}

.ctrighthideessentials-toggle,.ctrightshowessentials-toggle{
 	background-color: white;
    font-weight: bold;
    padding: 5px 2px !important;
    position: absolute;
    top: 0px !important;
    left: 49%;
    cursor: pointer;
    width: 14px;
    border: 1px solid #DDDDDD;
    /*border-left: 0;*/
    display: inline-block;
}
</style>
{/literal}

{if !$smarty.get._pjax}
<script async defer
	src="https://maps.googleapis.com/maps/api/js?key={$API_KEY}&callback=initMap">
	</script>
{/if}

<script type="text/javascript">
		
	jQuery(document).ready(function() {
		jQuery("#listmapdiv").on("click",".ctlefthideessentials-toggle",function(){
			if(jQuery('#mapdiv').css('display') == 'none') {
				jQuery('#listdiv').show();
				jQuery('#mapdiv').show();
				jQuery('.ctrightshowessentials-toggle').removeClass('ctrightshowessentials-toggle').addClass('ctrighthideessentials-toggle');
				jQuery('.ctrighthideessentials-toggle').find('span').removeClass('icon-chevron-left').addClass('icon-chevron-right');
				jQuery('#mapdiv').removeClass('span12').addClass('span6');
				jQuery('#listdiv').removeClass('span12').addClass('span6');
			}else{

				jQuery(this).removeClass('ctlefthideessentials-toggle').addClass('ctleftshowessentials-toggle');
				jQuery(this).find('span').removeClass('icon-chevron-left').addClass('icon-chevron-right');
				jQuery('#listdiv').hide();
				jQuery('#mapdiv').removeClass('span6').addClass('span12');
			}
		});


		jQuery("#listmapdiv").on("click",".ctleftshowessentials-toggle", function(){
			jQuery(this).removeClass('ctleftshowessentials-toggle').addClass('ctlefthideessentials-toggle');
			jQuery(this).find('span').removeClass('icon-chevron-right').addClass('icon-chevron-left');
			jQuery('#listdiv').show();
			jQuery('#mapdiv').removeClass('span12').addClass('span6');
		});

		jQuery("#listmapdiv").on("click",".ctrighthideessentials-toggle",function(){
			if(jQuery('#listdiv').css('display') == 'none') {
				jQuery('#listdiv').show();
				jQuery('#mapdiv').show();
				jQuery('.ctleftshowessentials-toggle').removeClass('ctleftshowessentials-toggle').addClass('ctlefthideessentials-toggle');
				jQuery('.ctlefthideessentials-toggle').find('span').removeClass('icon-chevron-right').addClass('icon-chevron-left');
				jQuery('#mapdiv').removeClass('span12').addClass('span6');
				jQuery('#listdiv').removeClass('span12').addClass('span6');
			}else{
				jQuery(this).removeClass('ctrighthideessentials-toggle').addClass('ctrightshowessentials-toggle');
				jQuery(this).find('span').removeClass('icon-chevron-right').addClass('icon-chevron-left');
				jQuery('#mapdiv').hide();
				jQuery('#listdiv').removeClass('span6').addClass('span12');
			}
		});

		jQuery("#listmapdiv").on("click",".ctrightshowessentials-toggle", function(){
			jQuery(this).removeClass('ctrightshowessentials-toggle').addClass('ctrighthideessentials-toggle');
			jQuery(this).find('span').removeClass('icon-chevron-left').addClass('icon-chevron-right');
			jQuery('#mapdiv').show();
			jQuery('#listdiv').removeClass('span12').addClass('span6');
		});
	});
</script>

{if $API_KEY neq ''}
	{literal}
		<script type='text/javascript'>
		var flightPath;
		var map;
		var markers = [];
		var flightPlanCoordinates = [];
		function initMap() {
			map = new google.maps.Map(document.getElementById('map'), {
			  zoom: 3,
			  center: {lat: 0, lng: -180},
			  mapTypeId: 'terrain'
			});

			var flightPlanCoordinates = [
			  {lat: 37.772, lng: -122.214},
			  {lat: 21.291, lng: -157.821},
			  {lat: -18.142, lng: 178.431},
			  {lat: -27.467, lng: 153.027}
			];
			flightPath = new google.maps.Polyline({
			  path: flightPlanCoordinates,
			  geodesic: true,
			  strokeColor: '#FF0000',
			  strokeOpacity: 1.0,
			  strokeWeight: 2
			});
			flightPath.setMap(null);
		}
		
		jQuery(document).ready(function () {
			loadMapMarker();
			function loadMapMarker(){
				var polilinedata = JSON.parse($("input[name=poliline_data]").val());
				var progressIndicatorElement = jQuery.progressIndicator({
	              'position' : 'html',
	              'blockInfo' : {
	               'enabled' : true
	              }
	            });
				
				progressIndicatorElement.progressIndicator({'mode' : 'hide'});
				var result2 = polilinedata;
				if(result2.length != 0){
					var flightPlanCoordinates2 = [];
					jQuery.each(result2, function(index, item) {
						flightPlanCoordinates2.push([item.label,item.lat,item.lng]);
					});
					initMap();
					map.setCenter({lat:flightPlanCoordinates2[0][1], lng:flightPlanCoordinates2[0][2]});
					map.setZoom(10);
					
					var infowindow = new google.maps.InfoWindow();

					var marker, i;

					for (i = 0; i < flightPlanCoordinates2.length; i++) {  
					  marker = new google.maps.Marker({
						position: new google.maps.LatLng(flightPlanCoordinates2[i][1], flightPlanCoordinates2[i][2]),
						map: map,
					  });
					
					  google.maps.event.addListener(marker, 'mouseover', (function(marker, i) {
						return function() {
						  infowindow.setContent(flightPlanCoordinates2[i][0]);
						  infowindow.open(map, marker);
						}
					  })(marker, i));
					  google.maps.event.addListener(marker, 'click', (function(marker, i) {
						return function() {
							 if (marker.getAnimation() !== null) {
							  marker.setAnimation(null);
							} else {
							  marker.setAnimation(google.maps.Animation.BOUNCE);
							}
						}
					  })(marker, i));
					}
				}else{
					initMap();
				}
			}
			jQuery(".clickDrawPoliline").on("click",".drawPoliline",function(e){
				
				e.preventDefault(); 
				e.stopPropagation();
				initMap();
				var flightPlanCoordinates = [];	
				flightPath = new google.maps.Polyline({
				  	path: flightPlanCoordinates,
				  	geodesic: true,
				  	strokeColor: '#FF0000',
				  	strokeOpacity: 1.0,
				  	strokeWeight: 2
				});
				flightPath.setMap(null);

				var polilinedata = JSON.parse($("input[name=poliline_data]").val());
				var element = jQuery(e.currentTarget);
				var recordid = element.closest('tr').attr('data-id');
				jQuery.each(polilinedata, function(index, item) {
					if(recordid == item.recordId){
						flightPlanCoordinates.push(item);
					}
				});
				
				map.setCenter({lat:flightPlanCoordinates[0].lat, lng:flightPlanCoordinates[0].lng});
				map.setZoom(20);
				var  infowindow = new google.maps.InfoWindow({
				    content: flightPlanCoordinates[0].label,
				});

				var marker = new google.maps.Marker({
				position: {lat:flightPlanCoordinates[0].lat, lng:flightPlanCoordinates[0].lng},
				    map,
				});
				infowindow.open(map, marker);

				var  infowindow = new google.maps.InfoWindow({
				    content: flightPlanCoordinates[1].label,
				});
				var marker = new google.maps.Marker({
				position: {lat:flightPlanCoordinates[1].lat, lng:flightPlanCoordinates[1].lng},
				    map,
				});
				infowindow.open(map, marker);
				flightPath = new google.maps.Polyline({
					path: flightPlanCoordinates,
					geodesic: true,
					strokeColor: '#FF0000',
					strokeOpacity: 1.0,
					strokeWeight: 2
				});
				flightPath.setMap(map);
			});
		});
		</script>
	{/literal}
{else}
	<script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js"></script>
	<link href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css" rel="stylesheet"/>
	{literal}
		<script type='text/javascript'>
				
			var markers = [];
			var myMap = '';
			var flightPlanCoordinates = [];
			function initOpenMap() {
			 	var element = document.getElementById('map');
				//element.style = 'height:300px;';
				myMap = L.map(element);

				// Add OSM tile leayer to the Leaflet map.
				L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
				    attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
				}).addTo(myMap);
			}
			jQuery(document).ready(function () { 
				var polilinedata = JSON.parse($("input[name=poliline_data]").val());
				var progressIndicatorElement = jQuery.progressIndicator({
		              'position' : 'html',
		              'blockInfo' : {
		               'enabled' : true
		              }
		        });
				progressIndicatorElement.progressIndicator({'mode' : 'hide'});
				var result2 = polilinedata;
				
				initOpenMap();
				if(result2.length != 0){
					
					var target = L.latLng(result2[0].lat,result2[0].lng);
					// Set map's center to target with zoom 14.
					myMap.setView(target, 20);

					var flightPlanCoordinates = [];
					jQuery.each(result2, function(index, item) {
						flightPlanCoordinates.push([item.label,item.lat,item.lng]);
						
					});
					var marker , i;
					for (i = 0; i < flightPlanCoordinates.length; i++) {
                    	marker = new L.marker([flightPlanCoordinates[i][1], flightPlanCoordinates[i][2]])
					    .bindPopup(flightPlanCoordinates[i][0])
					    .addTo(myMap);
					    marker.on('mouseover', function(event){
						  marker.openPopup();
						});
						markers[i] = marker;
                    }
				}else{
					initOpenMap();
				}

				//listviewcontent tr click event
				jQuery(".clickDrawPoliline").on("click",".drawPoliline",function(e){
			
					e.preventDefault(); 
					e.stopPropagation();
					
					L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
				    attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
					}).addTo(myMap);

					var polilinedata = JSON.parse($("input[name=poliline_data]").val());
					var element = jQuery(e.currentTarget);
					var recordid = element.closest('tr').attr('data-id');
					var flightPlanCoordinates = [];
					jQuery.each(polilinedata, function(index, item) {
						if(recordid == item.recordId){
							flightPlanCoordinates.push(item);
						}
					});
					var target = L.latLng(flightPlanCoordinates[0].lat,flightPlanCoordinates[0].lng);

					// Set map's center to target with zoom 14.
					myMap.setView(target, 20);

					var marker = new L.marker([flightPlanCoordinates[0].lat, flightPlanCoordinates[0].lng])
					    .bindPopup(flightPlanCoordinates[0].label)
					    .addTo(myMap);
					marker.openPopup(); 

					var marker = new L.marker([flightPlanCoordinates[1].lat, flightPlanCoordinates[1].lng])
					    .bindPopup(flightPlanCoordinates[1].label)
					    .addTo(myMap);
					marker.openPopup(); 

					var pointList = flightPlanCoordinates;

					var firstpolyline = new L.Polyline(pointList, {
					    color: 'red',
					    weight: 3,
					    opacity: 0.5,
					    smoothFactor: 1
					});
					firstpolyline.addTo(myMap);
				});
			});
		</script>
	{/literal}
{/if}

{strip}
<input type="hidden" id="view" value="{$VIEW}" />
<input type="hidden" id="pageStartRange" value="{$PAGING_MODEL->getRecordStartRange()}" />
<input type="hidden" id="pageEndRange" value="{$PAGING_MODEL->getRecordEndRange()}" />
<input type="hidden" id="previousPageExist" value="{$PAGING_MODEL->isPrevPageExists()}" />
<input type="hidden" id="nextPageExist" value="{$PAGING_MODEL->isNextPageExists()}" />
<input type="hidden" id="alphabetSearchKey" value= "{$MODULE_MODEL->getAlphabetSearchField()}" />
<input type="hidden" id="Operator" value="{$OPERATOR}" />
<input type="hidden" id="alphabetValue" value="{$ALPHABET_VALUE}" />
<input type="hidden" id="totalCount" value="{$LISTVIEW_COUNT}" />
<input type='hidden' value="{$PAGE_NUMBER}" id='pageNumber'>
<input type='hidden' value="{$PAGING_MODEL->getPageLimit()}" id='pageLimit'>
<input type="hidden" value="{$LISTVIEW_ENTRIES_COUNT}" id="noOfEntries">
<input type="hidden" name="poliline_data" value='{$MAPPOLILINE}'/>

{assign var = ALPHABETS_LABEL value = vtranslate('LBL_ALPHABETS', 'Vtiger')}
{assign var = ALPHABETS value = ','|explode:$ALPHABETS_LABEL}

<div class="row-fluid">
	<div class="span12" id="listmapdiv" style="margin-top:30px;">	
		<div class="span6" id="listdiv">
			<div class="alphabetSorting noprint">
				<table width="100%" class="table-bordered" style="border: 1px solid #ddd;table-layout: fixed">
					<tbody>
						<tr>
						{foreach item=ALPHABET from=$ALPHABETS}
							<td class="alphabetSearch textAlignCenter cursorPointer {if $ALPHABET_VALUE eq $ALPHABET} highlightBackgroundColor {/if}" style="padding : 0px !important"><a id="{$ALPHABET}" href="#">{$ALPHABET}</a></td>
						{/foreach}
						</tr>
					</tbody>
				</table>
			</div>
			<div id="selectAllMsgDiv" class="alert-block msgDiv noprint">
				<strong><a id="selectAllMsg">{vtranslate('LBL_SELECT_ALL',$MODULE)}&nbsp;{vtranslate($MODULE ,$MODULE)}&nbsp;(<span id="totalRecordsCount"></span>)</a></strong>
			</div>
			<div id="deSelectAllMsgDiv" class="alert-block msgDiv noprint">
				<strong><a id="deSelectAllMsg">{vtranslate('LBL_DESELECT_ALL_RECORDS',$MODULE)}</a></strong>
			</div>
			<div class="contents-topscroll noprint">
				<div class="topscroll-div">
					&nbsp;
				 </div>
			</div>
			<div class="listViewEntriesDiv contents-bottomscroll">
				<div class="bottomscroll-div">
				<input type="hidden" value="{$ORDER_BY}" id="orderBy">
				<input type="hidden" value="{$SORT_ORDER}" id="sortOrder">
				<span class="listViewLoadingImageBlock hide modal noprint" id="loadingListViewModal">
					<img class="listViewLoadingImage" src="{vimage_path('loading.gif')}" alt="no-image" title="{vtranslate('LBL_LOADING', $MODULE)}"/>
					<p class="listViewLoadingMsg">{vtranslate('LBL_LOADING_LISTVIEW_CONTENTS', $MODULE)}........</p>
				</span>
				{assign var=WIDTHTYPE value=$CURRENT_USER_MODEL->get('rowheight')}
				<table class="table table-bordered listViewEntriesTable">
					<thead>
						<tr class="listViewHeaders">
							<th width="5%">
								<input type="checkbox" id="listViewEntriesMainCheckBox" />
							</th>
							{foreach item=LISTVIEW_HEADER from=$LISTVIEW_HEADERS}
							<th nowrap {if $LISTVIEW_HEADER@last} colspan="2" {/if}>
								<a href="javascript:void(0);" class="listViewHeaderValues" data-nextsortorderval="{if $COLUMN_NAME eq $LISTVIEW_HEADER->get('column')}{$NEXT_SORT_ORDER}{else}ASC{/if}" data-columnname="{$LISTVIEW_HEADER->get('column')}">{vtranslate($LISTVIEW_HEADER->get('label'), $MODULE)}
									&nbsp;&nbsp;{if $COLUMN_NAME eq $LISTVIEW_HEADER->get('column')}<img class="{$SORT_IMAGE} icon-white">{/if}</a>
							</th>
							{/foreach}
						</tr>
					</thead>
			        {if $MODULE_MODEL->isQuickSearchEnabled()}
			        <tr>
			            <td></td>
						{foreach item=LISTVIEW_HEADER from=$LISTVIEW_HEADERS}
			             <td>
			                 {assign var=FIELD_UI_TYPE_MODEL value=$LISTVIEW_HEADER->getUITypeModel()}
			                {include file=vtemplate_path($FIELD_UI_TYPE_MODEL->getListSearchTemplateName(),$MODULE_NAME)
			                    FIELD_MODEL= $LISTVIEW_HEADER SEARCH_INFO=$SEARCH_DETAILS[$LISTVIEW_HEADER->getName()] USER_MODEL=$CURRENT_USER_MODEL}
			             </td>
						{/foreach}
						<td>
							<button class="btn" data-trigger="listSearch">{vtranslate('LBL_SEARCH', $MODULE )}</button>
						</td>
			        </tr>
			        {/if}
					{foreach item=LISTVIEW_ENTRY from=$LISTVIEW_ENTRIES name=listview}
					<tr class="listViewEntries clickDrawPoliline" data-id='{$LISTVIEW_ENTRY->getId()}' data-recordUrl='{$LISTVIEW_ENTRY->getDetailViewUrl()}' id="{$MODULE}_listView_row_{$smarty.foreach.listview.index+1}">
			            <td  width="5%" class="{$WIDTHTYPE}">
							<input type="checkbox" value="{$LISTVIEW_ENTRY->getId()}" class="listViewEntriesCheckBox"/>
						</td>
						{foreach item=LISTVIEW_HEADER from=$LISTVIEW_HEADERS}
						{assign var=LISTVIEW_HEADERNAME value=$LISTVIEW_HEADER->get('name')}
						<td class="listViewEntryValue drawPoliline {$WIDTHTYPE}" data-field-type="{$LISTVIEW_HEADER->getFieldDataType()}" nowrap>
							{if ($LISTVIEW_HEADER->isNameField() eq true or $LISTVIEW_HEADER->get('uitype') eq '4') and $MODULE_MODEL->isListViewNameFieldNavigationEnabled() eq true }
								<a href="{$LISTVIEW_ENTRY->getDetailViewUrl()}">{$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}</a>
							{else if $LISTVIEW_HEADER->get('uitype') eq '72'}
								{assign var=CURRENCY_SYMBOL_PLACEMENT value={$CURRENT_USER_MODEL->get('currency_symbol_placement')}}
								{if $CURRENCY_SYMBOL_PLACEMENT eq '1.0$'}
									{$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}{$LISTVIEW_ENTRY->get('currencySymbol')}
								{else}
									{$LISTVIEW_ENTRY->get('currencySymbol')}{$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}
								{/if}
							{else}
			                    {if $LISTVIEW_HEADER->getFieldDataType() eq 'double'}
			                        {decimalFormat($LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME))}
			                    {else}
			                        {$LISTVIEW_ENTRY->get($LISTVIEW_HEADERNAME)}
			                    {/if}
							{/if}
							{if $LISTVIEW_HEADER@last}
							</td><td nowrap class="{$WIDTHTYPE}">
							<div class="actions pull-right">
								<span class="actionImages">
									{if $LISTVIEW_ENTRY->getCheckInLocation() neq ',' AND $LISTVIEW_ENTRY->getCheckInLocation() neq ''}
							        	<a onclick='window.open("https://www.google.com/maps/search/?api=1&query={$LISTVIEW_ENTRY->getCheckInLocation()}");return false;'><i class="icon-map-marker" style="color:green;" title="{vtranslate('Click to see Check-in Location on Map',$MODULE)}" ></i></a>&nbsp;
							        {else}
							            <a onclick='return false;'><i class="icon-map-marker" title="{vtranslate('No Check-in Location',$MODULE)}" ></i></a>&nbsp;
							        {/if}

									{if $LISTVIEW_ENTRY->getCheckOutLocation() neq ',' AND $LISTVIEW_ENTRY->getCheckOutLocation() neq ''}
							        	<a onclick='window.open("https://www.google.com/maps/search/?api=1&query={$LISTVIEW_ENTRY->getCheckOutLocation()}");return false;'><i class="icon-map-marker" {if $LISTVIEW_ENTRY->getCheckOutLocation() neq ',' AND $LISTVIEW_ENTRY->getCheckOutLocation() neq ''} style="color:red;"{/if} title="{vtranslate('Click to see Check-out Location on Map',$MODULE)}"></i></a>&nbsp;
							        {else}
							          <a onclick='return false;'><i class="icon-map-marker" title="{vtranslate('No Check-out Location',$MODULE)}" ></i></a>&nbsp;
							        {/if}
									
									<a href="{$LISTVIEW_ENTRY->getFullDetailViewUrl()}"><i title="{vtranslate('LBL_SHOW_COMPLETE_DETAILS', $MODULE)}" class="icon-th-list alignMiddle"></i></a>&nbsp;
									{if $IS_MODULE_EDITABLE}
										<a href='{$LISTVIEW_ENTRY->getEditViewUrl()}'><i title="{vtranslate('LBL_EDIT', $MODULE)}" class="icon-pencil alignMiddle"></i></a>&nbsp;
									{/if}
									{if $IS_MODULE_DELETABLE}
										<a class="deleteRecordButton"><i title="{vtranslate('LBL_DELETE', $MODULE)}" class="icon-trash alignMiddle"></i></a>
									{/if}
								</span>
							</div></td>
							{/if}
						</td>
						{/foreach}
					</tr>
					{/foreach}
				</table>

				<!--added this div for Temporarily -->
				{if $LISTVIEW_ENTRIES_COUNT eq '0'}
					<table class="emptyRecordsDiv">
						<tbody>
							<tr>
								<td>
									{assign var=SINGLE_MODULE value="SINGLE_$MODULE"}
									{vtranslate('LBL_EQ_ZERO')} {vtranslate($SINGLE_MODULE, $MODULE)} {vtranslate('LBL_FOUND')}.{if $IS_MODULE_EDITABLE} {vtranslate('LBL_CREATE')} <a href="{$MODULE_MODEL->getCreateRecordUrl()}">{vtranslate($SINGLE_MODULE, $MODULE)}</a>{/if}
								</td>
							</tr>
						</tbody>
					</table>
				{/if}
				</div>
			</div>
			<div class="ctlefthideessentials-toggle" title="Listing Panel Show/Hide">
				<span class="essentials-toggle-marker fa cursorPointer icon-chevron-left"></span>
		</div>
	</div>

	<div id="mapdiv" class="span6">
		<div class="ctrighthideessentials-toggle" title="Map Panel Show/Hide">
			<span class="essentials-toggle-marker fa cursorPointer icon-chevron-right"></span>
		</div>
		<div id='map' style="min-height: 730px; margin: 0; padding: 0;"></div>
	</div>
</div> <!-- listmap div end -->
</div>
{/strip}
